/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.container;

import com.tiviacz.pizzacraft.blockentity.PizzaBagBlockEntity;
import com.tiviacz.pizzacraft.init.ModMenuTypes;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class PizzaBagMenu
extends AbstractContainerMenu {
    public Inventory inv;
    public PizzaBagBlockEntity blockEntity;

    public PizzaBagMenu(int windowID, Inventory inv, FriendlyByteBuf data) {
        this(windowID, inv, PizzaBagMenu.getBlockEntity(inv, data));
    }

    public PizzaBagMenu(int windowID, Inventory inv, BlockEntity blockEntity) {
        super((MenuType)ModMenuTypes.PIZZA_BAG.get(), windowID);
        this.inv = inv;
        this.blockEntity = (PizzaBagBlockEntity)blockEntity;
        this.addInventory();
        this.addPlayerInventoryAndHotbar(inv);
        this.blockEntity.startOpen(inv.f_35978_);
    }

    public void addPlayerInventoryAndHotbar(Inventory inv) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inv, x + y * 9 + 9, 8 + x * 18, 51 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inv, x, 8 + x * 18, 109));
        }
    }

    public void addInventory() {
        for (int j = 0; j < 6; ++j) {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.getInventory(), j, 36 + j * 18, 20));
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < 6 ? !this.m_38903_(itemstack1, 6, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, 6, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.blockEntity.stopOpen(player);
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    private static PizzaBagBlockEntity getBlockEntity(Inventory inv, FriendlyByteBuf data) {
        Objects.requireNonNull(inv, "inv cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity blockEntity = inv.f_35978_.f_19853_.m_7702_(data.m_130135_());
        if (blockEntity instanceof PizzaBagBlockEntity) {
            return (PizzaBagBlockEntity)blockEntity;
        }
        throw new IllegalStateException("Block entity is not correct! " + blockEntity);
    }
}

